<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CFileList extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
		$this->name = "filelist";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		if ($_GET["mod"] == $this->name) {

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			switch ($sub) {

				case "texts":
					return $this->__adminTexts();
				break;

				case "landing":
					$sub = "items";
				case "items":
				case "cats":
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;

				case "download":
					return $this->Download();
				break;

			}
		}
	}

	function Download() {

		$file = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:filelist_items']} WHERE item_id='%d'" , array($_GET["file"]));

		$mime = new CMime();
		$mime->Set("unknown");
		$mime->Filename($file["item_file_file"]);

		CFile::ReadChunked("../upload/filelist/" . $file["item_id"] . ".file");
		die();

	}



	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:filelist_items" , 
			"plugin:filelist_items_lang",
			"plugin:filelist_cats" , 
			"plugin:filelist_cats_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {


		$wid = $this->plugins["widgets"]->AddWidget(array(
			"type"			=> "cfilelistwidgetmenu",
			"type_name"		=> "Categories Menu",
			"title"			=> "Categories",
			"note"			=> "Auto-Generated",
			"settings"		=> array( "set_style"	=> "2"),
			"module"		=> $module_data["mod_id"],
		));

		$layout = $this->plugins["layouts"]->SaveLayout(
			array(
				"name"			=> $module_data["mod_name"] . " - Details",
				"block"			=> array(
					"col"	=> array(
						0 => array("size"	=> 4 , "widget"	=> $wid),
						1 => array("size"	=> 8 , "widget"	=> array( "__CONTENT__"  , $this->plugins["comments"]->GetCommentsWidget())),					
					)
				)				
			)
		);

		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout_details"			=> $layout,
			)
		);

		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));


		$this->plugins["modules"]->CreateLangRecord(
			$this->tables["plugin:filelist_cats"],
			$this->tables["plugin:filelist_cats_lang"],
			"cat_id",
			"cat_order",
			array(
				"module_id"		=> $module_data["mod_id"],
				"cat_title"		=> "Default Category",
				"cat_url"		=> "default-category",
				"cat_status"	=> "1",
				"cat_date"		=> time(),
			)
		);

	}


}

?>